package org.kodein.emoji.people_body.person

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonCurlyHair: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧑‍🦱",
        description = "person: curly hair",
        unicodeVersion = UnicodeVersion(12, 1),
        aliases = listOf("person-curly-hair", "curly-hair"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person: person: curly hair.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonCurlyHair: SkinTone1Emoji get() = _PersonCurlyHair

/**
 * Alias to emoji [PersonCurlyHair] (People & Body: person: person: curly hair).
*/
public val Emoji.Companion.CurlyHair: SkinTone1Emoji get() = _PersonCurlyHair
