package org.kodein.emoji.smileys_emotion.emotion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _EyeInSpeechBubble: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👁️‍🗨️",
        description = "eye in speech bubble",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("eye-in-speech-bubble", "eye-bubble"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: emotion: eye in speech bubble.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.EyeInSpeechBubble: Emoji get() = _EyeInSpeechBubble

/**
 * Alias to emoji [EyeInSpeechBubble] (Smileys & Emotion: emotion: eye in speech bubble).
*/
public val Emoji.Companion.EyeBubble: Emoji get() = _EyeInSpeechBubble
