package org.kodein.emoji.smileys_emotion.emotion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LeftSpeechBubble: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🗨️",
        description = "left speech bubble",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("left-speech-bubble", "speech-bubble-leftwards"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: emotion: left speech bubble.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LeftSpeechBubble: Emoji get() = _LeftSpeechBubble

/**
 * Alias to emoji [LeftSpeechBubble] (Smileys & Emotion: emotion: left speech bubble).
*/
public val Emoji.Companion.SpeechBubbleLeftwards: Emoji get() = _LeftSpeechBubble
