package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ConfusedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😕",
        description = "confused face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("confused-face", "slightly-frowning"),
        emoticons = listOf(":-/"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: confused face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ConfusedFace: Emoji get() = _ConfusedFace

/**
 * Alias to emoji [ConfusedFace] (Smileys & Emotion: face-concerned: confused face).
*/
public val Emoji.Companion.SlightlyFrowning: Emoji get() = _ConfusedFace
