package org.kodein.emoji.smileys_emotion.face_glasses

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithMonocle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧐",
        description = "face with monocle",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("face-with-monocle", "monocle"),
        emoticons = listOf("o~O"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-glasses: face with monocle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithMonocle: Emoji get() = _FaceWithMonocle

/**
 * Alias to emoji [FaceWithMonocle] (Smileys & Emotion: face-glasses: face with monocle).
*/
public val Emoji.Companion.Monocle: Emoji get() = _FaceWithMonocle
