package org.kodein.emoji.smileys_emotion.face_negative

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _EnragedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😡",
        description = "enraged face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("enraged-face", "rage"),
        emoticons = listOf(">:O"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-negative: enraged face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.EnragedFace: Emoji get() = _EnragedFace

/**
 * Alias to emoji [EnragedFace] (Smileys & Emotion: face-negative: enraged face).
*/
public val Emoji.Companion.Rage: Emoji get() = _EnragedFace
