package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DottedLineFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫥",
        description = "dotted line face",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("dotted-line-face", "invisible"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: dotted line face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DottedLineFace: Emoji get() = _DottedLineFace

/**
 * Alias to emoji [DottedLineFace] (Smileys & Emotion: face-neutral-skeptical: dotted line face).
*/
public val Emoji.Companion.Invisible: Emoji get() = _DottedLineFace
