package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RollingOnTheFloorLaughing: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤣",
        description = "rolling on the floor laughing",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("rolling-on-the-floor-laughing", "rofl"),
        emoticons = listOf("*>w<*"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-smiling: rolling on the floor laughing.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RollingOnTheFloorLaughing: Emoji get() = _RollingOnTheFloorLaughing

/**
 * Alias to emoji [RollingOnTheFloorLaughing] (Smileys & Emotion: face-smiling: rolling on the floor laughing).
*/
public val Emoji.Companion.Rofl: Emoji get() = _RollingOnTheFloorLaughing
