package org.kodein.emoji.smileys_emotion.face_unwell

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithCrossedOutEyes: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😵",
        description = "face with crossed-out eyes",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("face-with-crossed-out-eyes", "x-eyes"),
        emoticons = listOf("X_o"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-unwell: face with crossed-out eyes.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithCrossedOutEyes: Emoji get() = _FaceWithCrossedOutEyes

/**
 * Alias to emoji [FaceWithCrossedOutEyes] (Smileys & Emotion: face-unwell: face with crossed-out eyes).
*/
public val Emoji.Companion.XEyes: Emoji get() = _FaceWithCrossedOutEyes
