package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ReverseButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "◀️",
        description = "reverse button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("reverse-button", "reverse", "leftwards-triangle", "arrow-backward"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: reverse button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ReverseButton: Emoji get() = _ReverseButton

/**
 * Alias to emoji [ReverseButton] (Symbols: av-symbol: reverse button).
*/
public val Emoji.Companion.Reverse: Emoji get() = _ReverseButton

/**
 * Alias to emoji [ReverseButton] (Symbols: av-symbol: reverse button).
*/
public val Emoji.Companion.LeftwardsTriangle: Emoji get() = _ReverseButton

/**
 * Alias to emoji [ReverseButton] (Symbols: av-symbol: reverse button).
*/
public val Emoji.Companion.ArrowBackward: Emoji get() = _ReverseButton
