package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OrangeCircle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🟠",
        description = "orange circle",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("orange-circle", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: orange circle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OrangeCircle: Emoji get() = _OrangeCircle
