package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Keycap2: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "2️⃣",
        description = "keycap: 2",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("keycap-2", "two", "keycap-two"),
        emoticons = listOf(),
        notoImageRatio = 0.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: keycap: keycap: 2.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Keycap2: Emoji get() = _Keycap2

/**
 * Alias to emoji [Keycap2] (Symbols: keycap: keycap: 2).
*/
public val Emoji.Companion.Two: Emoji get() = _Keycap2

/**
 * Alias to emoji [Keycap2] (Symbols: keycap: keycap: 2).
*/
public val Emoji.Companion.KeycapTwo: Emoji get() = _Keycap2
