package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TradeMark: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "™️",
        description = "trade mark",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("trade-mark", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: other-symbol: trade mark.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TradeMark: Emoji get() = _TradeMark
