package org.kodein.emoji.travel_places.place_religious

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPlaceReligious() {
    add(intArrayOf(0x26ea), _Church)
    add(intArrayOf(0x1f54c), _Mosque)
    add(intArrayOf(0x1f6d5), _HinduTemple)
    add(intArrayOf(0x1f54d), _Synagogue)
    add(intArrayOf(0x26e9, 0xfe0f), _ShintoShrine)
    add(intArrayOf(0x26e9), _ShintoShrine)
    add(intArrayOf(0x1f54b), _Kaaba)
}

internal suspend fun SequenceScope<Emoji>.yieldAllPlaceReligious() {
    yield(_Church)
    yield(_Mosque)
    yield(_HinduTemple)
    yield(_Synagogue)
    yield(_ShintoShrine)
    yield(_Kaaba)
}

internal val countPlaceReligious = 6

/**
 * All Emoji of the Travel & Places: place-religious subgroup.
*/
public fun Emoji.Companion.sequencePlaceReligious(): Sequence<Emoji> =
    sequence { yieldAllPlaceReligious() }

/**
 * All Emoji of the Travel & Places: place-religious subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listPlaceReligious(): List<Emoji> =
    ArrayList<Emoji>(countPlaceReligious).also { list -> sequencePlaceReligious().forEach { list.add(it) } }

@Deprecated("Renamed listPlaceReligious.", replaceWith = ReplaceWith("listPlaceReligious()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allPlaceReligious(): List<Emoji> =
    listPlaceReligious()
