package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FirstQuarterMoon: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌓",
        description = "first quarter moon",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("first-quarter-moon", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: first quarter moon.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FirstQuarterMoon: Emoji get() = _FirstQuarterMoon
