package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FiveOclock: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🕔",
        description = "five o’clock",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("five-oclock", "five-o-clock"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: time: five o’clock.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FiveOclock: Emoji get() = _FiveOclock

/**
 * Alias to emoji [FiveOclock] (Travel & Places: time: five o’clock).
*/
public val Emoji.Companion.FiveOClock: Emoji get() = _FiveOclock
