package org.kodein.emoji.travel_places.transport_air

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllTransportAir() {
    add(intArrayOf(0x2708, 0xfe0f), _Airplane)
    add(intArrayOf(0x2708), _Airplane)
    add(intArrayOf(0x1f6e9, 0xfe0f), _SmallAirplane)
    add(intArrayOf(0x1f6e9), _SmallAirplane)
    add(intArrayOf(0x1f6eb), _AirplaneDeparture)
    add(intArrayOf(0x1f6ec), _AirplaneArrival)
    add(intArrayOf(0x1fa82), _Parachute)
    add(intArrayOf(0x1f4ba), _Seat)
    add(intArrayOf(0x1f681), _Helicopter)
    add(intArrayOf(0x1f69f), _SuspensionRailway)
    add(intArrayOf(0x1f6a0), _MountainCableway)
    add(intArrayOf(0x1f6a1), _AerialTramway)
    add(intArrayOf(0x1f6f0, 0xfe0f), _Satellite)
    add(intArrayOf(0x1f6f0), _Satellite)
    add(intArrayOf(0x1f680), _Rocket)
    add(intArrayOf(0x1f6f8), _FlyingSaucer)
}

internal suspend fun SequenceScope<Emoji>.yieldAllTransportAir() {
    yield(_Airplane)
    yield(_SmallAirplane)
    yield(_AirplaneDeparture)
    yield(_AirplaneArrival)
    yield(_Parachute)
    yield(_Seat)
    yield(_Helicopter)
    yield(_SuspensionRailway)
    yield(_MountainCableway)
    yield(_AerialTramway)
    yield(_Satellite)
    yield(_Rocket)
    yield(_FlyingSaucer)
}

internal val countTransportAir = 13

/**
 * All Emoji of the Travel & Places: transport-air subgroup.
*/
public fun Emoji.Companion.sequenceTransportAir(): Sequence<Emoji> =
    sequence { yieldAllTransportAir() }

/**
 * All Emoji of the Travel & Places: transport-air subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listTransportAir(): List<Emoji> =
    ArrayList<Emoji>(countTransportAir).also { list -> sequenceTransportAir().forEach { list.add(it) } }

@Deprecated("Renamed listTransportAir.", replaceWith = ReplaceWith("listTransportAir()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allTransportAir(): List<Emoji> =
    listTransportAir()
