package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LightRail: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚈",
        description = "light rail",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("light-rail", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: light rail.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LightRail: Emoji get() = _LightRail
