package org.kodein.emoji.flags

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.flags.flag.*
import org.kodein.emoji.flags.subdivision_flag.*
import org.kodein.emoji.flags.country_flag.*


internal fun EmojiFinder.addAllFlags() {
    addAllFlag()
    addAllSubdivisionFlag()
    addAllCountryFlag()
}

internal fun MutableList<Emoji>.addAllFlags() {
    addAllFlag()
    addAllSubdivisionFlag()
    addAllCountryFlag()
}

/**
 * All Emoji of the Flags group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFlags(): List<Emoji> =
    ArrayList<Emoji>(269).apply { addAllFlags() }

internal fun allFlagsSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "flag" to { Emoji.allFlag() },
        "subdivision_flag" to { Emoji.allSubdivisionFlag() },
        "country_flag" to { Emoji.allCountryFlag() },
    )
