package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagHeardMcdonaldIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇭🇲",
        description = "flag: Heard & McDonald Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-heard-mcdonald-islands", "heard-mcdonald-islands-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Heard & McDonald Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagHeardMcdonaldIslands: Emoji get() = _FlagHeardMcdonaldIslands

/**
 * Alias to emoji [FlagHeardMcdonaldIslands] (Flags: country-flag: flag: Heard & McDonald Islands).
*/
public val Emoji.Companion.HeardMcdonaldIslandsFlag: Emoji get() = _FlagHeardMcdonaldIslands
