package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagPanama: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇵🇦",
        description = "flag: Panama",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-panama", "panama-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Panama.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagPanama: Emoji get() = _FlagPanama

/**
 * Alias to emoji [FlagPanama] (Flags: country-flag: flag: Panama).
*/
public val Emoji.Companion.PanamaFlag: Emoji get() = _FlagPanama
