package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSanMarino: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇲",
        description = "flag: San Marino",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-san-marino", "san-marino-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: San Marino.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSanMarino: Emoji get() = _FlagSanMarino

/**
 * Alias to emoji [FlagSanMarino] (Flags: country-flag: flag: San Marino).
*/
public val Emoji.Companion.SanMarinoFlag: Emoji get() = _FlagSanMarino
