package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSeychelles: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇨",
        description = "flag: Seychelles",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-seychelles", "seychelles-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Seychelles.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSeychelles: Emoji get() = _FlagSeychelles

/**
 * Alias to emoji [FlagSeychelles] (Flags: country-flag: flag: Seychelles).
*/
public val Emoji.Companion.SeychellesFlag: Emoji get() = _FlagSeychelles
