package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSintMaarten: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇽",
        description = "flag: Sint Maarten",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-sint-maarten", "sint-maarten-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Sint Maarten.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSintMaarten: Emoji get() = _FlagSintMaarten

/**
 * Alias to emoji [FlagSintMaarten] (Flags: country-flag: flag: Sint Maarten).
*/
public val Emoji.Companion.SintMaartenFlag: Emoji get() = _FlagSintMaarten
