package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllGeometric() {
    add(intArrayOf(0x1f534), _RedCircle)
    add(intArrayOf(0x1f7e0), _OrangeCircle)
    add(intArrayOf(0x1f7e1), _YellowCircle)
    add(intArrayOf(0x1f7e2), _GreenCircle)
    add(intArrayOf(0x1f535), _BlueCircle)
    add(intArrayOf(0x1f7e3), _PurpleCircle)
    add(intArrayOf(0x1f7e4), _BrownCircle)
    add(intArrayOf(0x26ab), _BlackCircle)
    add(intArrayOf(0x26aa), _WhiteCircle)
    add(intArrayOf(0x1f7e5), _RedSquare)
    add(intArrayOf(0x1f7e7), _OrangeSquare)
    add(intArrayOf(0x1f7e8), _YellowSquare)
    add(intArrayOf(0x1f7e9), _GreenSquare)
    add(intArrayOf(0x1f7e6), _BlueSquare)
    add(intArrayOf(0x1f7ea), _PurpleSquare)
    add(intArrayOf(0x1f7eb), _BrownSquare)
    add(intArrayOf(0x2b1b), _BlackLargeSquare)
    add(intArrayOf(0x2b1c), _WhiteLargeSquare)
    add(intArrayOf(0x1f53b), _RedTrianglePointedDown)
    add(intArrayOf(0x1f53a), _RedTrianglePointedUp)
    add(intArrayOf(0x1f536), _LargeOrangeDiamond)
    add(intArrayOf(0x1f538), _SmallOrangeDiamond)
    add(intArrayOf(0x1f4a0), _DiamondWithADot)
    add(intArrayOf(0x1f537), _LargeBlueDiamond)
    add(intArrayOf(0x1f539), _SmallBlueDiamond)
    add(intArrayOf(0x1f518), _RadioButton)
    add(intArrayOf(0x1f533), _WhiteSquareButton)
    add(intArrayOf(0x25fc, 0xfe0f), _BlackMediumSquare)
    add(intArrayOf(0x25fc), _BlackMediumSquare)
    add(intArrayOf(0x25fe), _BlackMediumSmallSquare)
    add(intArrayOf(0x25aa, 0xfe0f), _BlackSmallSquare)
    add(intArrayOf(0x25aa), _BlackSmallSquare)
    add(intArrayOf(0x1f532), _BlackSquareButton)
    add(intArrayOf(0x25fb, 0xfe0f), _WhiteMediumSquare)
    add(intArrayOf(0x25fb), _WhiteMediumSquare)
    add(intArrayOf(0x25fd), _WhiteMediumSmallSquare)
    add(intArrayOf(0x25ab, 0xfe0f), _WhiteSmallSquare)
    add(intArrayOf(0x25ab), _WhiteSmallSquare)
}

internal fun MutableList<Emoji>.addAllGeometric() {
    add(_RedCircle)
    add(_OrangeCircle)
    add(_YellowCircle)
    add(_GreenCircle)
    add(_BlueCircle)
    add(_PurpleCircle)
    add(_BrownCircle)
    add(_BlackCircle)
    add(_WhiteCircle)
    add(_RedSquare)
    add(_OrangeSquare)
    add(_YellowSquare)
    add(_GreenSquare)
    add(_BlueSquare)
    add(_PurpleSquare)
    add(_BrownSquare)
    add(_BlackLargeSquare)
    add(_WhiteLargeSquare)
    add(_RedTrianglePointedDown)
    add(_RedTrianglePointedUp)
    add(_LargeOrangeDiamond)
    add(_SmallOrangeDiamond)
    add(_DiamondWithADot)
    add(_LargeBlueDiamond)
    add(_SmallBlueDiamond)
    add(_RadioButton)
    add(_WhiteSquareButton)
    add(_BlackMediumSquare)
    add(_BlackMediumSmallSquare)
    add(_BlackSmallSquare)
    add(_BlackSquareButton)
    add(_WhiteMediumSquare)
    add(_WhiteMediumSmallSquare)
    add(_WhiteSmallSquare)
}

/**
 * All Emoji of the Symbols: geometric subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allGeometric(): List<Emoji> =
    ArrayList<Emoji>(34).apply { addAllGeometric() }
