package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Keycap4: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "4️⃣",
        description = "keycap: 4",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("keycap-4", "four", "keycap-four"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: keycap: keycap: 4.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Keycap4: Emoji get() = _Keycap4

/**
 * Alias to emoji [Keycap4] (Symbols: keycap: keycap: 4).
*/
public val Emoji.Companion.Four: Emoji get() = _Keycap4

/**
 * Alias to emoji [Keycap4] (Symbols: keycap: keycap: 4).
*/
public val Emoji.Companion.KeycapFour: Emoji get() = _Keycap4
