package org.kodein.emoji.symbols.zodiac

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Ophiuchus: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⛎",
        description = "Ophiuchus",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("ophiuchus", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Symbols: zodiac: Ophiuchus.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Ophiuchus: Emoji get() = _Ophiuchus
