package org.kodein.emoji.activities.event

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MoonViewingCeremony: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎑",
        description = "moon viewing ceremony",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("moon-viewing-ceremony", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: event: moon viewing ceremony.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MoonViewingCeremony: Emoji get() = _MoonViewingCeremony
