package org.kodein.emoji.objects.book_paper

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllBookPaper() {
    add(intArrayOf(0x1f4d6), _OpenBook)
    add(intArrayOf(0x1f4da), _Books)
    add(intArrayOf(0x1f4d2), _Ledger)
    add(intArrayOf(0x1f4d4), _NotebookWithDecorativeCover)
    add(intArrayOf(0x1f4d5), _ClosedBook)
    add(intArrayOf(0x1f4d3), _Notebook)
    add(intArrayOf(0x1f4d7), _GreenBook)
    add(intArrayOf(0x1f4d8), _BlueBook)
    add(intArrayOf(0x1f4d9), _OrangeBook)
    add(intArrayOf(0x1f516), _Bookmark)
    add(intArrayOf(0x1f4c4), _PageFacingUp)
    add(intArrayOf(0x1f4c3), _PageWithCurl)
    add(intArrayOf(0x1f4d1), _BookmarkTabs)
    add(intArrayOf(0x1f4f0), _Newspaper)
    add(intArrayOf(0x1f5de, 0xfe0f), _RolledUpNewspaper)
    add(intArrayOf(0x1f5de), _RolledUpNewspaper)
    add(intArrayOf(0x1f3f7, 0xfe0f), _Label)
    add(intArrayOf(0x1f3f7), _Label)
    add(intArrayOf(0x1f4dc), _Scroll)
}

internal fun MutableList<Emoji>.addAllBookPaper() {
    add(_OpenBook)
    add(_Books)
    add(_Ledger)
    add(_NotebookWithDecorativeCover)
    add(_ClosedBook)
    add(_Notebook)
    add(_GreenBook)
    add(_BlueBook)
    add(_OrangeBook)
    add(_Bookmark)
    add(_PageFacingUp)
    add(_PageWithCurl)
    add(_BookmarkTabs)
    add(_Newspaper)
    add(_RolledUpNewspaper)
    add(_Label)
    add(_Scroll)
}

/**
 * All Emoji of the Objects: book-paper subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allBookPaper(): List<Emoji> =
    ArrayList<Emoji>(17).apply { addAllBookPaper() }
