package org.kodein.emoji.objects.computer

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ComputerDisk: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💽",
        description = "computer disk",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("computer-disk", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: computer: computer disk.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ComputerDisk: Emoji get() = _ComputerDisk
