package org.kodein.emoji.objects.writing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BlackNib: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "✒️",
        description = "black nib",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("black-nib", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: writing: black nib.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BlackNib: Emoji get() = _BlackNib
