package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _UpArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⬆️",
        description = "up arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("up-arrow", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: arrow: up arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.UpArrow: Emoji get() = _UpArrow
