package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PickupTruck: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🛻",
        description = "pickup truck",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("pickup-truck", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: pickup truck.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PickupTruck: Emoji get() = _PickupTruck
