package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBangladesh: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇩",
        description = "flag: Bangladesh",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-bangladesh", "bangladesh-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Bangladesh.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBangladesh: Emoji get() = _FlagBangladesh

/**
 * Alias to emoji [FlagBangladesh] (Flags: country-flag: flag: Bangladesh).
*/
public val Emoji.Companion.BangladeshFlag: Emoji get() = _FlagBangladesh
