package org.kodein.emoji.food_drink.food_fruit

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Tangerine: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🍊",
        description = "tangerine",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("tangerine", "orange", "mandarin"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Food & Drink: food-fruit: tangerine.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Tangerine: Emoji get() = _Tangerine

/**
 * Alias to emoji [Tangerine] (Food & Drink: food-fruit: tangerine).
*/
public val Emoji.Companion.Orange: Emoji get() = _Tangerine

/**
 * Alias to emoji [Tangerine] (Food & Drink: food-fruit: tangerine).
*/
public val Emoji.Companion.Mandarin: Emoji get() = _Tangerine
