package org.kodein.emoji.objects.lock

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllLock() {
    add(intArrayOf(0x1f5dd, 0xfe0f), _OldKey)
    add(intArrayOf(0x1f5dd), _OldKey)
    add(intArrayOf(0x1f511), _Key)
    add(intArrayOf(0x1f510), _LockedWithKey)
    add(intArrayOf(0x1f50f), _LockedWithPen)
    add(intArrayOf(0x1f512), _Locked)
    add(intArrayOf(0x1f513), _Unlocked)
}

internal fun MutableList<Emoji>.addAllLock() {
    add(_OldKey)
    add(_Key)
    add(_LockedWithKey)
    add(_LockedWithPen)
    add(_Locked)
    add(_Unlocked)
}

/**
 * All Emoji of the Objects: lock subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allLock(): List<Emoji> =
    ArrayList<Emoji>(6).apply { addAllLock() }
