package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BarChart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📊",
        description = "bar chart",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("bar-chart", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: office: bar chart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BarChart: Emoji get() = _BarChart
