package org.kodein.emoji.people_body.body_parts

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllBodyParts() {
    add(intArrayOf(0x1f9e0), _Brain)
    add(intArrayOf(0x1fac0), _AnatomicalHeart)
    add(intArrayOf(0x1fac1), _Lungs)
    add(intArrayOf(0x1f9b7), _Tooth)
    add(intArrayOf(0x1f9b4), _Bone)
    add(intArrayOf(0x1f440), _Eyes)
    add(intArrayOf(0x1f441, 0xfe0f), _Eye)
    add(intArrayOf(0x1f441), _Eye)
    add(intArrayOf(0x1f444), _Mouth)
    add(intArrayOf(0x1fae6), _BitingLip)
    add(intArrayOf(0x1f445), _Tongue)
    add(intArrayOf(0x1f443), _Nose)
    addVariations(intArrayOf(0x1f443, 0x0), _Nose, 1)
    add(intArrayOf(0x1f442), _Ear)
    addVariations(intArrayOf(0x1f442, 0x0), _Ear, 1)
    add(intArrayOf(0x1f9bb), _EarWithHearingAid)
    addVariations(intArrayOf(0x1f9bb, 0x0), _EarWithHearingAid, 1)
    add(intArrayOf(0x1f9b6), _Foot)
    addVariations(intArrayOf(0x1f9b6, 0x0), _Foot, 1)
    add(intArrayOf(0x1f9b5), _Leg)
    addVariations(intArrayOf(0x1f9b5, 0x0), _Leg, 1)
    add(intArrayOf(0x1f9bf), _MechanicalLeg)
    add(intArrayOf(0x1f9be), _MechanicalArm)
    add(intArrayOf(0x1f4aa), _FlexedBiceps)
    addVariations(intArrayOf(0x1f4aa, 0x0), _FlexedBiceps, 1)
}

internal fun MutableList<Emoji>.addAllBodyParts() {
    add(_Brain)
    add(_AnatomicalHeart)
    add(_Lungs)
    add(_Tooth)
    add(_Bone)
    add(_Eyes)
    add(_Eye)
    add(_Mouth)
    add(_BitingLip)
    add(_Tongue)
    add(_Nose)
    add(_Ear)
    add(_EarWithHearingAid)
    add(_Foot)
    add(_Leg)
    add(_MechanicalLeg)
    add(_MechanicalArm)
    add(_FlexedBiceps)
}

/**
 * All Emoji of the People & Body: body-parts subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allBodyParts(): List<Emoji> =
    ArrayList<Emoji>(18).apply { addAllBodyParts() }
