package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MeltingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫠",
        description = "melting face",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("melting-face", "melting"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-smiling: melting face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MeltingFace: Emoji get() = _MeltingFace

/**
 * Alias to emoji [MeltingFace] (Smileys & Emotion: face-smiling: melting face).
*/
public val Emoji.Companion.Melting: Emoji get() = _MeltingFace
