package org.kodein.emoji.symbols

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.symbols.av_symbol.*
import org.kodein.emoji.symbols.gender.*
import org.kodein.emoji.symbols.arrow.*
import org.kodein.emoji.symbols.zodiac.*
import org.kodein.emoji.symbols.other_symbol.*
import org.kodein.emoji.symbols.keycap.*
import org.kodein.emoji.symbols.religion.*
import org.kodein.emoji.symbols.alphanum.*
import org.kodein.emoji.symbols.transport_sign.*
import org.kodein.emoji.symbols.geometric.*
import org.kodein.emoji.symbols.punctuation.*
import org.kodein.emoji.symbols.warning.*
import org.kodein.emoji.symbols.currency.*
import org.kodein.emoji.symbols.math.*


internal fun EmojiFinder.addAllSymbols() {
    addAllAvSymbol()
    addAllGender()
    addAllArrow()
    addAllZodiac()
    addAllOtherSymbol()
    addAllKeycap()
    addAllReligion()
    addAllAlphanum()
    addAllTransportSign()
    addAllGeometric()
    addAllPunctuation()
    addAllWarning()
    addAllCurrency()
    addAllMath()
}

internal fun MutableList<Emoji>.addAllSymbols() {
    addAllAvSymbol()
    addAllGender()
    addAllArrow()
    addAllZodiac()
    addAllOtherSymbol()
    addAllKeycap()
    addAllReligion()
    addAllAlphanum()
    addAllTransportSign()
    addAllGeometric()
    addAllPunctuation()
    addAllWarning()
    addAllCurrency()
    addAllMath()
}

/**
 * All Emoji of the Symbols group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allSymbols(): List<Emoji> =
    ArrayList<Emoji>(223).apply { addAllSymbols() }

internal fun allSymbolsSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "av_symbol" to { Emoji.allAvSymbol() },
        "gender" to { Emoji.allGender() },
        "arrow" to { Emoji.allArrow() },
        "zodiac" to { Emoji.allZodiac() },
        "other_symbol" to { Emoji.allOtherSymbol() },
        "keycap" to { Emoji.allKeycap() },
        "religion" to { Emoji.allReligion() },
        "alphanum" to { Emoji.allAlphanum() },
        "transport_sign" to { Emoji.allTransportSign() },
        "geometric" to { Emoji.allGeometric() },
        "punctuation" to { Emoji.allPunctuation() },
        "warning" to { Emoji.allWarning() },
        "currency" to { Emoji.allCurrency() },
        "math" to { Emoji.allMath() },
    )
