package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _InputLatinLetters: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔤",
        description = "input latin letters",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("input-latin-letters", "letters", "abc"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: input latin letters.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.InputLatinLetters: Emoji get() = _InputLatinLetters

/**
 * Alias to emoji [InputLatinLetters] (Symbols: alphanum: input latin letters).
*/
public val Emoji.Companion.Letters: Emoji get() = _InputLatinLetters

/**
 * Alias to emoji [InputLatinLetters] (Symbols: alphanum: input latin letters).
*/
public val Emoji.Companion.Abc: Emoji get() = _InputLatinLetters
