package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ElevenOclock: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🕚",
        description = "eleven o’clock",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("eleven-oclock", "eleven-o-clock"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: time: eleven o’clock.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ElevenOclock: Emoji get() = _ElevenOclock

/**
 * Alias to emoji [ElevenOclock] (Travel & Places: time: eleven o’clock).
*/
public val Emoji.Companion.ElevenOClock: Emoji get() = _ElevenOclock
