package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMacaoSarChina: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇴",
        description = "flag: Macao SAR China",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-macao-sar-china", "macau-sar-china-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Macao SAR China.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMacaoSarChina: Emoji get() = _FlagMacaoSarChina

/**
 * Alias to emoji [FlagMacaoSarChina] (Flags: country-flag: flag: Macao SAR China).
*/
public val Emoji.Companion.MacauSarChinaFlag: Emoji get() = _FlagMacaoSarChina
