package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSuriname: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇷",
        description = "flag: Suriname",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-suriname", "suriname-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Suriname.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSuriname: Emoji get() = _FlagSuriname

/**
 * Alias to emoji [FlagSuriname] (Flags: country-flag: flag: Suriname).
*/
public val Emoji.Companion.SurinameFlag: Emoji get() = _FlagSuriname
