package org.kodein.emoji.food_drink.food_fruit

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _KiwiFruit: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥝",
        description = "kiwi fruit",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("kiwi-fruit", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Food & Drink: food-fruit: kiwi fruit.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.KiwiFruit: Emoji get() = _KiwiFruit
