package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPersonSport() {
    add(intArrayOf(0x1f93a), _PersonFencing)
    add(intArrayOf(0x1f3c7), _HorseRacing)
    addVariations(intArrayOf(0x1f3c7, 0x0), _HorseRacing, 1)
    add(intArrayOf(0x26f7, 0xfe0f), _Skier)
    add(intArrayOf(0x26f7), _Skier)
    add(intArrayOf(0x1f3c2), _Snowboarder)
    addVariations(intArrayOf(0x1f3c2, 0x0), _Snowboarder, 1)
    add(intArrayOf(0x1f3cc, 0xfe0f), _PersonGolfing)
    add(intArrayOf(0x1f3cc), _PersonGolfing)
    addVariations(intArrayOf(0x1f3cc, 0x0), _PersonGolfing, 1)
    add(intArrayOf(0x1f3cc, 0xfe0f, 0x200d, 0x2642), _ManGolfing)
    add(intArrayOf(0x1f3cc, 0xfe0f, 0x200d, 0x2642, 0xfe0f), _ManGolfing)
    add(intArrayOf(0x1f3cc, 0x200d, 0x2642, 0xfe0f), _ManGolfing)
    addVariations(intArrayOf(0x1f3cc, 0x0, 0x200d, 0x2642, 0xfe0f), _ManGolfing, 1)
    add(intArrayOf(0x1f3cc, 0x200d, 0x2642), _ManGolfing)
    addVariations(intArrayOf(0x1f3cc, 0x0, 0x200d, 0x2642), _ManGolfing, 1)
    add(intArrayOf(0x1f3cc, 0xfe0f, 0x200d, 0x2640), _WomanGolfing)
    add(intArrayOf(0x1f3cc, 0xfe0f, 0x200d, 0x2640, 0xfe0f), _WomanGolfing)
    add(intArrayOf(0x1f3cc, 0x200d, 0x2640, 0xfe0f), _WomanGolfing)
    addVariations(intArrayOf(0x1f3cc, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanGolfing, 1)
    add(intArrayOf(0x1f3cc, 0x200d, 0x2640), _WomanGolfing)
    addVariations(intArrayOf(0x1f3cc, 0x0, 0x200d, 0x2640), _WomanGolfing, 1)
    add(intArrayOf(0x1f3c4), _PersonSurfing)
    addVariations(intArrayOf(0x1f3c4, 0x0), _PersonSurfing, 1)
    add(intArrayOf(0x1f3c4, 0x200d, 0x2642), _ManSurfing)
    addVariations(intArrayOf(0x1f3c4, 0x0, 0x200d, 0x2642), _ManSurfing, 1)
    add(intArrayOf(0x1f3c4, 0x200d, 0x2642, 0xfe0f), _ManSurfing)
    addVariations(intArrayOf(0x1f3c4, 0x0, 0x200d, 0x2642, 0xfe0f), _ManSurfing, 1)
    add(intArrayOf(0x1f3c4, 0x200d, 0x2640), _WomanSurfing)
    addVariations(intArrayOf(0x1f3c4, 0x0, 0x200d, 0x2640), _WomanSurfing, 1)
    add(intArrayOf(0x1f3c4, 0x200d, 0x2640, 0xfe0f), _WomanSurfing)
    addVariations(intArrayOf(0x1f3c4, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanSurfing, 1)
    add(intArrayOf(0x1f6a3), _PersonRowingBoat)
    addVariations(intArrayOf(0x1f6a3, 0x0), _PersonRowingBoat, 1)
    add(intArrayOf(0x1f6a3, 0x200d, 0x2642), _ManRowingBoat)
    addVariations(intArrayOf(0x1f6a3, 0x0, 0x200d, 0x2642), _ManRowingBoat, 1)
    add(intArrayOf(0x1f6a3, 0x200d, 0x2642, 0xfe0f), _ManRowingBoat)
    addVariations(intArrayOf(0x1f6a3, 0x0, 0x200d, 0x2642, 0xfe0f), _ManRowingBoat, 1)
    add(intArrayOf(0x1f6a3, 0x200d, 0x2640), _WomanRowingBoat)
    addVariations(intArrayOf(0x1f6a3, 0x0, 0x200d, 0x2640), _WomanRowingBoat, 1)
    add(intArrayOf(0x1f6a3, 0x200d, 0x2640, 0xfe0f), _WomanRowingBoat)
    addVariations(intArrayOf(0x1f6a3, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanRowingBoat, 1)
    add(intArrayOf(0x1f3ca), _PersonSwimming)
    addVariations(intArrayOf(0x1f3ca, 0x0), _PersonSwimming, 1)
    add(intArrayOf(0x1f3ca, 0x200d, 0x2642), _ManSwimming)
    addVariations(intArrayOf(0x1f3ca, 0x0, 0x200d, 0x2642), _ManSwimming, 1)
    add(intArrayOf(0x1f3ca, 0x200d, 0x2642, 0xfe0f), _ManSwimming)
    addVariations(intArrayOf(0x1f3ca, 0x0, 0x200d, 0x2642, 0xfe0f), _ManSwimming, 1)
    add(intArrayOf(0x1f3ca, 0x200d, 0x2640), _WomanSwimming)
    addVariations(intArrayOf(0x1f3ca, 0x0, 0x200d, 0x2640), _WomanSwimming, 1)
    add(intArrayOf(0x1f3ca, 0x200d, 0x2640, 0xfe0f), _WomanSwimming)
    addVariations(intArrayOf(0x1f3ca, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanSwimming, 1)
    add(intArrayOf(0x26f9, 0xfe0f), _PersonBouncingBall)
    add(intArrayOf(0x26f9), _PersonBouncingBall)
    addVariations(intArrayOf(0x26f9, 0x0), _PersonBouncingBall, 1)
    add(intArrayOf(0x26f9, 0xfe0f, 0x200d, 0x2642), _ManBouncingBall)
    add(intArrayOf(0x26f9, 0xfe0f, 0x200d, 0x2642, 0xfe0f), _ManBouncingBall)
    add(intArrayOf(0x26f9, 0x200d, 0x2642, 0xfe0f), _ManBouncingBall)
    addVariations(intArrayOf(0x26f9, 0x0, 0x200d, 0x2642, 0xfe0f), _ManBouncingBall, 1)
    add(intArrayOf(0x26f9, 0x200d, 0x2642), _ManBouncingBall)
    addVariations(intArrayOf(0x26f9, 0x0, 0x200d, 0x2642), _ManBouncingBall, 1)
    add(intArrayOf(0x26f9, 0xfe0f, 0x200d, 0x2640), _WomanBouncingBall)
    add(intArrayOf(0x26f9, 0xfe0f, 0x200d, 0x2640, 0xfe0f), _WomanBouncingBall)
    add(intArrayOf(0x26f9, 0x200d, 0x2640, 0xfe0f), _WomanBouncingBall)
    addVariations(intArrayOf(0x26f9, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanBouncingBall, 1)
    add(intArrayOf(0x26f9, 0x200d, 0x2640), _WomanBouncingBall)
    addVariations(intArrayOf(0x26f9, 0x0, 0x200d, 0x2640), _WomanBouncingBall, 1)
    add(intArrayOf(0x1f3cb, 0xfe0f), _PersonLiftingWeights)
    add(intArrayOf(0x1f3cb), _PersonLiftingWeights)
    addVariations(intArrayOf(0x1f3cb, 0x0), _PersonLiftingWeights, 1)
    add(intArrayOf(0x1f3cb, 0xfe0f, 0x200d, 0x2642), _ManLiftingWeights)
    add(intArrayOf(0x1f3cb, 0xfe0f, 0x200d, 0x2642, 0xfe0f), _ManLiftingWeights)
    add(intArrayOf(0x1f3cb, 0x200d, 0x2642, 0xfe0f), _ManLiftingWeights)
    addVariations(intArrayOf(0x1f3cb, 0x0, 0x200d, 0x2642, 0xfe0f), _ManLiftingWeights, 1)
    add(intArrayOf(0x1f3cb, 0x200d, 0x2642), _ManLiftingWeights)
    addVariations(intArrayOf(0x1f3cb, 0x0, 0x200d, 0x2642), _ManLiftingWeights, 1)
    add(intArrayOf(0x1f3cb, 0xfe0f, 0x200d, 0x2640), _WomanLiftingWeights)
    add(intArrayOf(0x1f3cb, 0xfe0f, 0x200d, 0x2640, 0xfe0f), _WomanLiftingWeights)
    add(intArrayOf(0x1f3cb, 0x200d, 0x2640, 0xfe0f), _WomanLiftingWeights)
    addVariations(intArrayOf(0x1f3cb, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanLiftingWeights, 1)
    add(intArrayOf(0x1f3cb, 0x200d, 0x2640), _WomanLiftingWeights)
    addVariations(intArrayOf(0x1f3cb, 0x0, 0x200d, 0x2640), _WomanLiftingWeights, 1)
    add(intArrayOf(0x1f6b4), _PersonBiking)
    addVariations(intArrayOf(0x1f6b4, 0x0), _PersonBiking, 1)
    add(intArrayOf(0x1f6b4, 0x200d, 0x2642), _ManBiking)
    addVariations(intArrayOf(0x1f6b4, 0x0, 0x200d, 0x2642), _ManBiking, 1)
    add(intArrayOf(0x1f6b4, 0x200d, 0x2642, 0xfe0f), _ManBiking)
    addVariations(intArrayOf(0x1f6b4, 0x0, 0x200d, 0x2642, 0xfe0f), _ManBiking, 1)
    add(intArrayOf(0x1f6b4, 0x200d, 0x2640), _WomanBiking)
    addVariations(intArrayOf(0x1f6b4, 0x0, 0x200d, 0x2640), _WomanBiking, 1)
    add(intArrayOf(0x1f6b4, 0x200d, 0x2640, 0xfe0f), _WomanBiking)
    addVariations(intArrayOf(0x1f6b4, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanBiking, 1)
    add(intArrayOf(0x1f6b5), _PersonMountainBiking)
    addVariations(intArrayOf(0x1f6b5, 0x0), _PersonMountainBiking, 1)
    add(intArrayOf(0x1f6b5, 0x200d, 0x2642), _ManMountainBiking)
    addVariations(intArrayOf(0x1f6b5, 0x0, 0x200d, 0x2642), _ManMountainBiking, 1)
    add(intArrayOf(0x1f6b5, 0x200d, 0x2642, 0xfe0f), _ManMountainBiking)
    addVariations(intArrayOf(0x1f6b5, 0x0, 0x200d, 0x2642, 0xfe0f), _ManMountainBiking, 1)
    add(intArrayOf(0x1f6b5, 0x200d, 0x2640), _WomanMountainBiking)
    addVariations(intArrayOf(0x1f6b5, 0x0, 0x200d, 0x2640), _WomanMountainBiking, 1)
    add(intArrayOf(0x1f6b5, 0x200d, 0x2640, 0xfe0f), _WomanMountainBiking)
    addVariations(intArrayOf(0x1f6b5, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanMountainBiking, 1)
    add(intArrayOf(0x1f938), _PersonCartwheeling)
    addVariations(intArrayOf(0x1f938, 0x0), _PersonCartwheeling, 1)
    add(intArrayOf(0x1f938, 0x200d, 0x2642), _ManCartwheeling)
    addVariations(intArrayOf(0x1f938, 0x0, 0x200d, 0x2642), _ManCartwheeling, 1)
    add(intArrayOf(0x1f938, 0x200d, 0x2642, 0xfe0f), _ManCartwheeling)
    addVariations(intArrayOf(0x1f938, 0x0, 0x200d, 0x2642, 0xfe0f), _ManCartwheeling, 1)
    add(intArrayOf(0x1f938, 0x200d, 0x2640), _WomanCartwheeling)
    addVariations(intArrayOf(0x1f938, 0x0, 0x200d, 0x2640), _WomanCartwheeling, 1)
    add(intArrayOf(0x1f938, 0x200d, 0x2640, 0xfe0f), _WomanCartwheeling)
    addVariations(intArrayOf(0x1f938, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanCartwheeling, 1)
    add(intArrayOf(0x1f93c), _PeopleWrestling)
    add(intArrayOf(0x1f93c, 0x200d, 0x2642), _MenWrestling)
    add(intArrayOf(0x1f93c, 0x200d, 0x2642, 0xfe0f), _MenWrestling)
    add(intArrayOf(0x1f93c, 0x200d, 0x2640), _WomenWrestling)
    add(intArrayOf(0x1f93c, 0x200d, 0x2640, 0xfe0f), _WomenWrestling)
    add(intArrayOf(0x1f93d), _PersonPlayingWaterPolo)
    addVariations(intArrayOf(0x1f93d, 0x0), _PersonPlayingWaterPolo, 1)
    add(intArrayOf(0x1f93d, 0x200d, 0x2642), _ManPlayingWaterPolo)
    addVariations(intArrayOf(0x1f93d, 0x0, 0x200d, 0x2642), _ManPlayingWaterPolo, 1)
    add(intArrayOf(0x1f93d, 0x200d, 0x2642, 0xfe0f), _ManPlayingWaterPolo)
    addVariations(intArrayOf(0x1f93d, 0x0, 0x200d, 0x2642, 0xfe0f), _ManPlayingWaterPolo, 1)
    add(intArrayOf(0x1f93d, 0x200d, 0x2640), _WomanPlayingWaterPolo)
    addVariations(intArrayOf(0x1f93d, 0x0, 0x200d, 0x2640), _WomanPlayingWaterPolo, 1)
    add(intArrayOf(0x1f93d, 0x200d, 0x2640, 0xfe0f), _WomanPlayingWaterPolo)
    addVariations(intArrayOf(0x1f93d, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanPlayingWaterPolo, 1)
    add(intArrayOf(0x1f93e), _PersonPlayingHandball)
    addVariations(intArrayOf(0x1f93e, 0x0), _PersonPlayingHandball, 1)
    add(intArrayOf(0x1f93e, 0x200d, 0x2642), _ManPlayingHandball)
    addVariations(intArrayOf(0x1f93e, 0x0, 0x200d, 0x2642), _ManPlayingHandball, 1)
    add(intArrayOf(0x1f93e, 0x200d, 0x2642, 0xfe0f), _ManPlayingHandball)
    addVariations(intArrayOf(0x1f93e, 0x0, 0x200d, 0x2642, 0xfe0f), _ManPlayingHandball, 1)
    add(intArrayOf(0x1f93e, 0x200d, 0x2640), _WomanPlayingHandball)
    addVariations(intArrayOf(0x1f93e, 0x0, 0x200d, 0x2640), _WomanPlayingHandball, 1)
    add(intArrayOf(0x1f93e, 0x200d, 0x2640, 0xfe0f), _WomanPlayingHandball)
    addVariations(intArrayOf(0x1f93e, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanPlayingHandball, 1)
    add(intArrayOf(0x1f939), _PersonJuggling)
    addVariations(intArrayOf(0x1f939, 0x0), _PersonJuggling, 1)
    add(intArrayOf(0x1f939, 0x200d, 0x2642), _ManJuggling)
    addVariations(intArrayOf(0x1f939, 0x0, 0x200d, 0x2642), _ManJuggling, 1)
    add(intArrayOf(0x1f939, 0x200d, 0x2642, 0xfe0f), _ManJuggling)
    addVariations(intArrayOf(0x1f939, 0x0, 0x200d, 0x2642, 0xfe0f), _ManJuggling, 1)
    add(intArrayOf(0x1f939, 0x200d, 0x2640), _WomanJuggling)
    addVariations(intArrayOf(0x1f939, 0x0, 0x200d, 0x2640), _WomanJuggling, 1)
    add(intArrayOf(0x1f939, 0x200d, 0x2640, 0xfe0f), _WomanJuggling)
    addVariations(intArrayOf(0x1f939, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanJuggling, 1)
}

internal suspend fun SequenceScope<Emoji>.yieldAllPersonSport() {
    yield(_PersonFencing)
    yield(_HorseRacing)
    yield(_Skier)
    yield(_Snowboarder)
    yield(_PersonGolfing)
    yield(_ManGolfing)
    yield(_WomanGolfing)
    yield(_PersonSurfing)
    yield(_ManSurfing)
    yield(_WomanSurfing)
    yield(_PersonRowingBoat)
    yield(_ManRowingBoat)
    yield(_WomanRowingBoat)
    yield(_PersonSwimming)
    yield(_ManSwimming)
    yield(_WomanSwimming)
    yield(_PersonBouncingBall)
    yield(_ManBouncingBall)
    yield(_WomanBouncingBall)
    yield(_PersonLiftingWeights)
    yield(_ManLiftingWeights)
    yield(_WomanLiftingWeights)
    yield(_PersonBiking)
    yield(_ManBiking)
    yield(_WomanBiking)
    yield(_PersonMountainBiking)
    yield(_ManMountainBiking)
    yield(_WomanMountainBiking)
    yield(_PersonCartwheeling)
    yield(_ManCartwheeling)
    yield(_WomanCartwheeling)
    yield(_PeopleWrestling)
    yield(_MenWrestling)
    yield(_WomenWrestling)
    yield(_PersonPlayingWaterPolo)
    yield(_ManPlayingWaterPolo)
    yield(_WomanPlayingWaterPolo)
    yield(_PersonPlayingHandball)
    yield(_ManPlayingHandball)
    yield(_WomanPlayingHandball)
    yield(_PersonJuggling)
    yield(_ManJuggling)
    yield(_WomanJuggling)
}

internal val countPersonSport = 43

/**
 * All Emoji of the People & Body: person-sport subgroup.
*/
public fun Emoji.Companion.sequencePersonSport(): Sequence<Emoji> =
    sequence { yieldAllPersonSport() }

/**
 * All Emoji of the People & Body: person-sport subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listPersonSport(): List<Emoji> =
    ArrayList<Emoji>(countPersonSport).also { list -> sequencePersonSport().forEach { list.add(it) } }

@Deprecated("Renamed listPersonSport.", replaceWith = ReplaceWith("listPersonSport()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allPersonSport(): List<Emoji> =
    listPersonSport()
