package org.kodein.emoji.symbols.zodiac

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Libra: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♎",
        description = "Libra",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("libra", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Symbols: zodiac: Libra.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Libra: Emoji get() = _Libra
