package org.kodein.emoji.travel_places.place_building

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HouseWithGarden: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏡",
        description = "house with garden",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("house-with-garden", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: place-building: house with garden.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HouseWithGarden: Emoji get() = _HouseWithGarden
