package org.kodein.emoji.activities.award_medal

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllAwardMedal() {
    add(intArrayOf(0x1f396, 0xfe0f), _MilitaryMedal)
    add(intArrayOf(0x1f396), _MilitaryMedal)
    add(intArrayOf(0x1f3c6), _Trophy)
    add(intArrayOf(0x1f3c5), _SportsMedal)
    add(intArrayOf(0x1f947), _FirstPlaceMedal)
    add(intArrayOf(0x1f948), _SecondPlaceMedal)
    add(intArrayOf(0x1f949), _ThirdPlaceMedal)
}

internal suspend fun SequenceScope<Emoji>.yieldAllAwardMedal() {
    yield(_MilitaryMedal)
    yield(_Trophy)
    yield(_SportsMedal)
    yield(_FirstPlaceMedal)
    yield(_SecondPlaceMedal)
    yield(_ThirdPlaceMedal)
}

internal val countAwardMedal = 6

/**
 * All Emoji of the Activities: award-medal subgroup.
*/
public fun Emoji.Companion.sequenceAwardMedal(): Sequence<Emoji> =
    sequence { yieldAllAwardMedal() }

/**
 * All Emoji of the Activities: award-medal subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listAwardMedal(): List<Emoji> =
    ArrayList<Emoji>(countAwardMedal).also { list -> sequenceAwardMedal().forEach { list.add(it) } }

@Deprecated("Renamed listAwardMedal.", replaceWith = ReplaceWith("listAwardMedal()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allAwardMedal(): List<Emoji> =
    listAwardMedal()
