package org.kodein.emoji.animals_nature.animal_mammal

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Hippopotamus: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🦛",
        description = "hippopotamus",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("hippopotamus", "hippo"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Animals & Nature: animal-mammal: hippopotamus.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Hippopotamus: Emoji get() = _Hippopotamus

/**
 * Alias to emoji [Hippopotamus] (Animals & Nature: animal-mammal: hippopotamus).
*/
public val Emoji.Companion.Hippo: Emoji get() = _Hippopotamus
